﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace MojaPierwszaGraXNA
{
    class VertexPositionNormalTextureTangentBinormal : IVertexType
    {
        public Vector4 Position;
        public Vector3 Normal;
        public Vector2 TextureCoordinate;
        public Vector3 Tangent;
        public Vector3 Binormal;

        private readonly static VertexElement[] VertexElements =
        {
            new VertexElement(0,VertexElementFormat.Vector4,VertexElementUsage.Position,0),
            new VertexElement(4,VertexElementFormat.Vector3,VertexElementUsage.Normal,0),
            new VertexElement(7,VertexElementFormat.Vector2,VertexElementUsage.TextureCoordinate,0),
            new VertexElement(9,VertexElementFormat.Vector3,VertexElementUsage.TextureCoordinate,3), //VertexElementUsage.Tangent
            new VertexElement(12,VertexElementFormat.Vector3,VertexElementUsage.TextureCoordinate,4), //VertexElementUsage.Binormal
        };

        public readonly static VertexDeclaration _VertexDeclaration = new VertexDeclaration(/*15,*/ VertexElements);

        VertexDeclaration IVertexType.VertexDeclaration
        {
            get
            {
                return _VertexDeclaration;
            }
        }
    }
}
